import * as React from 'react';
import { GridPinnedRowsPosition } from "../rows/gridRowsInterfaces.js";
import { type GridRenderContext, type GridColumnsRenderContext, type GridRowEntry, type GridRowId } from "../../../models/index.js";
export type VirtualScroller = ReturnType<typeof useGridVirtualScroller>;
export declare const EMPTY_DETAIL_PANELS: Readonly<Map<GridRowId, React.ReactNode>>;
export declare const useGridVirtualScroller: () => {
  renderContext: GridRenderContext;
  setPanels: React.Dispatch<React.SetStateAction<Readonly<Map<GridRowId, React.ReactNode>>>>;
  getRows: (params?: {
    rows?: GridRowEntry[];
    position?: GridPinnedRowsPosition;
    renderContext?: GridRenderContext;
  }) => React.ReactNode[];
  getContainerProps: () => {
    ref: (node: HTMLDivElement | null) => (() => void) | undefined;
  };
  getScrollerProps: () => {
    ref: React.RefObject<HTMLDivElement | null>;
    onScroll: () => void;
    onWheel: (event: React.WheelEvent) => void;
    onTouchMove: (event: React.TouchEvent) => void;
    style: React.CSSProperties;
    role: string;
    tabIndex: number | undefined;
  };
  getContentProps: () => {
    style: React.CSSProperties;
    role: string;
    ref: (node: HTMLDivElement | null) => void;
  };
  getRenderZoneProps: () => {
    role: string;
  };
  getScrollbarVerticalProps: () => {
    ref: React.RefObject<HTMLDivElement | null>;
    scrollPosition: React.RefObject<{
      top: number;
      left: number;
    }>;
  };
  getScrollbarHorizontalProps: () => {
    ref: React.RefObject<HTMLDivElement | null>;
    scrollPosition: React.RefObject<{
      top: number;
      left: number;
    }>;
  };
  getScrollAreaProps: () => {
    scrollPosition: React.RefObject<{
      top: number;
      left: number;
    }>;
  };
};
export declare function areRenderContextsEqual(context1: GridRenderContext, context2: GridRenderContext): boolean;
export declare function computeOffsetLeft(columnPositions: number[], renderContext: GridColumnsRenderContext, pinnedLeftLength: number): number;